/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.rhino.regexp;

import dev.latvian.mods.rhino.BaseFunction;
import dev.latvian.mods.rhino.Context;
import dev.latvian.mods.rhino.ScriptRuntime;
import dev.latvian.mods.rhino.Scriptable;
import dev.latvian.mods.rhino.TopLevel;
import dev.latvian.mods.rhino.Undefined;
import dev.latvian.mods.rhino.regexp.NativeRegExp;
import dev.latvian.mods.rhino.regexp.RegExp;

class NativeRegExpCtor
extends BaseFunction {
    private static final int Id_multiline = 1;
    private static final int Id_STAR = 2;
    private static final int Id_input = 3;
    private static final int Id_UNDERSCORE = 4;
    private static final int Id_lastMatch = 5;
    private static final int Id_AMPERSAND = 6;
    private static final int Id_lastParen = 7;
    private static final int Id_PLUS = 8;
    private static final int Id_leftContext = 9;
    private static final int Id_BACK_QUOTE = 10;
    private static final int Id_rightContext = 11;
    private static final int Id_QUOTE = 12;
    private static final int DOLLAR_ID_BASE = 12;
    private static final int Id_DOLLAR_1 = 13;
    private static final int Id_DOLLAR_2 = 14;
    private static final int Id_DOLLAR_3 = 15;
    private static final int Id_DOLLAR_4 = 16;
    private static final int Id_DOLLAR_5 = 17;
    private static final int Id_DOLLAR_6 = 18;
    private static final int Id_DOLLAR_7 = 19;
    private static final int Id_DOLLAR_8 = 20;
    private static final int Id_DOLLAR_9 = 21;
    private static final int MAX_INSTANCE_ID = 21;
    private int multilineAttr = 4;
    private int starAttr = 4;
    private int inputAttr = 4;
    private int underscoreAttr = 4;

    private static RegExp getImpl() {
        Context cx = Context.getCurrentContext();
        return ScriptRuntime.getRegExpProxy(cx);
    }

    NativeRegExpCtor() {
    }

    @Override
    public String getFunctionName() {
        return "RegExp";
    }

    @Override
    public int getLength() {
        return 2;
    }

    @Override
    public int getArity() {
        return 2;
    }

    @Override
    public Object call(Context cx, Scriptable scope, Scriptable thisObj, Object[] args) {
        if (args.length > 0 && args[0] instanceof NativeRegExp && (args.length == 1 || args[1] == Undefined.instance)) {
            return args[0];
        }
        return this.construct(cx, scope, args);
    }

    @Override
    public Scriptable construct(Context cx, Scriptable scope, Object[] args) {
        NativeRegExp re = new NativeRegExp();
        re.compile(cx, scope, args);
        ScriptRuntime.setBuiltinProtoAndParent(re, scope, TopLevel.Builtins.RegExp);
        return re;
    }

    @Override
    protected int getMaxInstanceId() {
        return super.getMaxInstanceId() + 21;
    }

    @Override
    protected int findInstanceIdInfo(String s) {
        int id;
        switch (s) {
            case "multiline": {
                int n = 1;
                break;
            }
            case "$*": {
                int n = 2;
                break;
            }
            case "input": {
                int n = 3;
                break;
            }
            case "$_": {
                int n = 4;
                break;
            }
            case "lastMatch": {
                int n = 5;
                break;
            }
            case "$&": {
                int n = 6;
                break;
            }
            case "lastParen": {
                int n = 7;
                break;
            }
            case "$+": {
                int n = 8;
                break;
            }
            case "leftContext": {
                int n = 9;
                break;
            }
            case "$`": {
                int n = 10;
                break;
            }
            case "rightContext": {
                int n = 11;
                break;
            }
            case "$'": {
                int n = 12;
                break;
            }
            case "$1": {
                int n = 13;
                break;
            }
            case "$2": {
                int n = 14;
                break;
            }
            case "$3": {
                int n = 15;
                break;
            }
            case "$4": {
                int n = 16;
                break;
            }
            case "$5": {
                int n = 17;
                break;
            }
            case "$6": {
                int n = 18;
                break;
            }
            case "$7": {
                int n = 19;
                break;
            }
            case "$8": {
                int n = 20;
                break;
            }
            case "$9": {
                int n = 21;
                break;
            }
            default: {
                int n = id = 0;
            }
        }
        if (id == 0) {
            return super.findInstanceIdInfo(s);
        }
        int attr = switch (id) {
            case 1 -> this.multilineAttr;
            case 2 -> this.starAttr;
            case 3 -> this.inputAttr;
            case 4 -> this.underscoreAttr;
            default -> 5;
        };
        return NativeRegExpCtor.instanceIdInfo(attr, super.getMaxInstanceId() + id);
    }

    @Override
    protected String getInstanceIdName(int id) {
        int shifted = id - super.getMaxInstanceId();
        if (1 <= shifted && shifted <= 21) {
            return switch (shifted) {
                case 1 -> "multiline";
                case 2 -> "$*";
                case 3 -> "input";
                case 4 -> "$_";
                case 5 -> "lastMatch";
                case 6 -> "$&";
                case 7 -> "lastParen";
                case 8 -> "$+";
                case 9 -> "leftContext";
                case 10 -> "$`";
                case 11 -> "rightContext";
                case 12 -> "$'";
                case 13 -> "$1";
                case 14 -> "$2";
                case 15 -> "$3";
                case 16 -> "$4";
                case 17 -> "$5";
                case 18 -> "$6";
                case 19 -> "$7";
                case 20 -> "$8";
                case 21 -> "$9";
                default -> super.getInstanceIdName(id);
            };
        }
        return super.getInstanceIdName(id);
    }

    @Override
    protected Object getInstanceIdValue(int id) {
        int shifted = id - super.getMaxInstanceId();
        if (1 <= shifted && shifted <= 21) {
            Object stringResult;
            RegExp impl = NativeRegExpCtor.getImpl();
            switch (shifted) {
                case 1: 
                case 2: {
                    return ScriptRuntime.wrapBoolean(impl.multiline);
                }
                case 3: 
                case 4: {
                    stringResult = impl.input;
                    break;
                }
                case 5: 
                case 6: {
                    stringResult = impl.lastMatch;
                    break;
                }
                case 7: 
                case 8: {
                    stringResult = impl.lastParen;
                    break;
                }
                case 9: 
                case 10: {
                    stringResult = impl.leftContext;
                    break;
                }
                case 11: 
                case 12: {
                    stringResult = impl.rightContext;
                    break;
                }
                default: {
                    int substring_number = shifted - 12 - 1;
                    stringResult = impl.getParenSubString(substring_number);
                    break;
                }
            }
            return stringResult == null ? "" : stringResult.toString();
        }
        return super.getInstanceIdValue(id);
    }

    @Override
    protected void setInstanceIdValue(int id, Object value) {
        int shifted = id - super.getMaxInstanceId();
        switch (shifted) {
            case 1: 
            case 2: {
                NativeRegExpCtor.getImpl().multiline = ScriptRuntime.toBoolean(value);
                return;
            }
            case 3: 
            case 4: {
                NativeRegExpCtor.getImpl().input = ScriptRuntime.toString(value);
                return;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                return;
            }
        }
        int substring_number = shifted - 12 - 1;
        if (0 <= substring_number && substring_number <= 8) {
            return;
        }
        super.setInstanceIdValue(id, value);
    }

    @Override
    protected void setInstanceIdAttributes(int id, int attr) {
        int shifted = id - super.getMaxInstanceId();
        switch (shifted) {
            case 1: {
                this.multilineAttr = attr;
                return;
            }
            case 2: {
                this.starAttr = attr;
                return;
            }
            case 3: {
                this.inputAttr = attr;
                return;
            }
            case 4: {
                this.underscoreAttr = attr;
                return;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                return;
            }
        }
        int substring_number = shifted - 12 - 1;
        if (0 <= substring_number && substring_number <= 8) {
            return;
        }
        super.setInstanceIdAttributes(id, attr);
    }
}

